SplashScreen = copy_table(BaseView)
SplashScreen.definition = {}


function SplashScreen:init(options)
    BaseView.init(self)
    local current = options and options.screen or 1

    local extra = file_load_lua_table("extra/config.lua")
    local scr = extra.splash[current]

    if scr.bitmap then
        local def = {
            type = "Bitmap",
            bitmap = scr.bitmap,
            x = 0, y = 0, z = 0,
        }
        self:create_and_add_object(def)
    end
    
    if scr.effect then
        create_combo_fx(self, scr.effect, 0, 0, 100)
    end

    if scr.music then
        snd_play_music(scr.music, false)
    end
    
    self.timer = scr.time or 3
    
    if extra.splash[current + 1] then
        self.next = current + 1
    end
end


function SplashScreen:update(dt)
    BaseView.update(self, dt)
    
    self.timer = self.timer - dt
    
    if self.timer < 0 or mouse.left_click then
        if self.next then
            fw:change_view(SplashScreen, { screen = self.next })
        else
            fw:change_view(MainMenu)
        end
    end
end
